<?php
class ModelUserUserLevel extends Model {
	public function addUserLevel($data) {
		$this->db->query("INSERT INTO `" . DB_PREFIX . "jpos_user_level` SET name = '" . $this->db->escape($data['name']) . "', user_group_id = '" . (int)$data['user_group_id'] . "', salt = '" . $this->db->escape($salt = token(9)) . "', date_added = NOW()");
	
		return $this->db->getLastId();
	}

	public function editUserLevel($jpos_user_level_id, $data) {
		$this->db->query("UPDATE `" . DB_PREFIX . "jpos_user_level` SET name = '" . $this->db->escape($data['name']) . "'  WHERE jpos_user_level_id = '" . (int)$jpos_user_level_id . "'");
	}
 
	public function deleteUserLevel($jpos_user_level_id) {
		$this->db->query("DELETE FROM `" . DB_PREFIX . "jpos_user_level` WHERE jpos_user_level_id = '" . (int)$jpos_user_level_id . "'");
	}

	public function getUserLevel($jpos_user_level_id) {
		$query = $this->db->query("SELECT *, (SELECT * FROM `" . DB_PREFIX . "jpos_user_level` WHERE jpos_user_level_id = '" . (int)$jpos_user_level_id . "'");

		return $query->row;
	}

	public function getUserLevelByname($name) {
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "jpos_user_level` WHERE name = '" . $this->db->escape($name) . "'");

		return $query->row;
	}
 
	public function getUserLevels($data = array()) {		
	    $sql = "SELECT * FROM `" . DB_PREFIX . "jpos_user_level` ";
		// end star

		$sort_data = array(
			'name', 
			'date_added'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY name";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalUserLevels() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "jpos_user_level`");

		return $query->row['total'];
	} 
 
}