<?php
class ModelJposUser extends Model {
	public function addJposUser($data) {
		$this->db->query("INSERT INTO `" . DB_PREFIX . "jpos_user` SET username = '" . $this->db->escape($data['username']) . "', salt = '" . $this->db->escape($salt = token(9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "', firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "', access_token = '" . $this->db->escape($data['access_token']) . "', image = '" . $this->db->escape($data['image']) . "', status = '" . (int)$data['status'] . "', date_added = NOW()");

		$jpos_user_id = $this->db->getLastId();

		$this->db->query("UPDATE `" . DB_PREFIX . "jpos_user` SET store_name = '" . $this->db->escape($data['store_name']) . "', store_owner = '" . $this->db->escape($data['store_owner']) . "', store_address = '" . $this->db->escape($data['store_address']) . "', store_email = '" . $this->db->escape($data['store_email']) . "', store_telephone = '" . $this->db->escape($data['store_telephone']) . "', store_logo = '" . $this->db->escape($data['store_logo']) . "' WHERE jpos_user_id = '" . (int)$jpos_user_id . "'");

		if (isset($data['locations'])) {
			foreach ($data['locations'] as $jpos_location_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "jpos_user_to_location SET jpos_user_id = '" . (int)$jpos_user_id . "', jpos_location_id = '" . (int)$jpos_location_id . "'");
			}
		}

		return $jpos_user_id;
	}

	public function editJposUser($jpos_user_id, $data) {

		//$this->db->query("UPDATE `" . DB_PREFIX . "jpos_user` SET username = '" . $this->db->escape($data['username']) . "', firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "', image = '" . $this->db->escape($data['image']) . "', status = '" . (int)$data['status'] . "' WHERE jpos_user_id = '" . (int)$jpos_user_id . "'");
		
		$this->db->query("UPDATE `" . DB_PREFIX . "jpos_user` SET username = '" . $this->db->escape($data['username']) . "', firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "', access_token = '" . $this->db->escape($data['access_token']) . "', image = '" . $this->db->escape($data['image']) . "', status = '" . (int)$data['status'] . "', jpos_user_level_id = '" . (int)$data['jpos_user_level_id'] . "' WHERE jpos_user_id = '" . (int)$jpos_user_id . "'");

		$this->db->query("UPDATE `" . DB_PREFIX . "jpos_user` SET store_name = '" . $this->db->escape($data['store_name']) . "', store_owner = '" . $this->db->escape($data['store_owner']) . "', store_address = '" . $this->db->escape($data['store_address']) . "', store_email = '" . $this->db->escape($data['store_email']) . "', store_telephone = '" . $this->db->escape($data['store_telephone']) . "', store_logo = '" . $this->db->escape($data['store_logo']) . "' WHERE jpos_user_id = '" . (int)$jpos_user_id . "'");

		if ($data['password']) {
			$this->db->query("UPDATE `" . DB_PREFIX . "jpos_user` SET salt = '" . $this->db->escape($salt = token(9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "' WHERE jpos_user_id = '" . (int)$jpos_user_id . "'");
		}


		$this->db->query("DELETE FROM " . DB_PREFIX . "jpos_user_to_location WHERE jpos_user_id = '" . (int)$jpos_user_id . "'");

		if (isset($data['locations'])) {
			foreach ($data['locations'] as $jpos_location_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "jpos_user_to_location SET jpos_user_id = '" . (int)$jpos_user_id . "', jpos_location_id = '" . (int)$jpos_location_id . "'");
			}
		}
	}

	public function editPassword($jpos_user_id, $password) {
		$this->db->query("UPDATE `" . DB_PREFIX . "jpos_user` SET salt = '" . $this->db->escape($salt = token(9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($password)))) . "', code = '' WHERE jpos_user_id = '" . (int)$jpos_user_id . "'");
	}

	public function editCode($email, $code) {
		$this->db->query("UPDATE `" . DB_PREFIX . "jpos_user` SET code = '" . $this->db->escape($code) . "' WHERE LCASE(email) = '" . $this->db->escape(utf8_strtolower($email)) . "'");
	}

	public function deleteJposUser($jpos_user_id) {
		$this->db->query("DELETE FROM `" . DB_PREFIX . "jpos_user` WHERE jpos_user_id = '" . (int)$jpos_user_id . "'");

		$this->db->query("DELETE FROM `" . DB_PREFIX . "jpos_user_to_location` WHERE jpos_user_id = '" . (int)$jpos_user_id . "'");
	}

	public function getJposUser($jpos_user_id) {
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "jpos_user` u WHERE u.jpos_user_id = '" . (int)$jpos_user_id . "'");

		if ($query->num_rows) {
			$query->row['locations'] = $this->getJposUserLocations($jpos_user_id);
		}


		return $query->row;
	}

	public function getJposUserLocations($jpos_user_id) {
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "jpos_user_to_location` WHERE jpos_user_id = '" . (int)$jpos_user_id . "'");
		$location_data = array();
		foreach ($query->rows as $row) {
			$location_data[] = $row['jpos_location_id'];
		}
		return $location_data;
	}

	public function getJposUserByUsername($username) {
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "jpos_user` WHERE username = '" . $this->db->escape($username) . "'");

		return $query->row;
	}

	public function getJposUserByEmail($email) {
		$query = $this->db->query("SELECT DISTINCT * FROM `" . DB_PREFIX . "jpos_user` WHERE LCASE(email) = '" . $this->db->escape(utf8_strtolower($email)) . "'");

		return $query->row;
	}

	public function getJposUserByCode($code) {
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "jpos_user` WHERE code = '" . $this->db->escape($code) . "' AND code != ''");

		return $query->row;
	}

	public function getJposUsers($data = array()) {
		$sql = "SELECT * FROM `" . DB_PREFIX . "jpos_user`";

		$sort_data = array(
			'username',
			'status',
			'date_added'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY username";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalJposUsers() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "jpos_user`");

		return $query->row['total'];
	}

	public function getTotalJposUsersByEmail($email) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "jpos_user` WHERE LCASE(email) = '" . $this->db->escape(utf8_strtolower($email)) . "'");

		return $query->row['total'];
	}
}