<?php
class ModelJposLocation extends Model {
	public function addLocation($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "jpos_location SET name = '" . $this->db->escape($data['name']) . "', description = '" . $this->db->escape($data['description']) . "', country_id = '" . (int)$data['country_id'] . "', date_added = NOW()");

		$jpos_location_id = $this->db->getLastId();

		if (isset($data['currency_ids'])) {
			foreach ($data['currency_ids'] as $currency_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "jpos_location_to_currency SET jpos_location_id = '" . (int)$jpos_location_id . "', currency_id = '" . (int)$currency_id . "'");
			}
		}

		if (isset($data['language_ids'])) {
			foreach ($data['language_ids'] as $language_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "jpos_location_to_language SET jpos_location_id = '" . (int)$jpos_location_id . "', language_id = '" . (int)$language_id . "'");
			}
		}

		return $jpos_location_id;
	}

	public function editLocation($jpos_location_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "jpos_location SET name = '" . $this->db->escape($data['name']) . "', description = '" . $this->db->escape($data['description']) . "', country_id = '" . (int)$data['country_id'] . "', date_modified = NOW() WHERE jpos_location_id = '" . (int)$jpos_location_id . "'");

		$this->db->query("DELETE FROM " . DB_PREFIX . "jpos_location_to_currency WHERE jpos_location_id = '" . (int)$jpos_location_id . "'");

		if (isset($data['currency_ids'])) {
			foreach ($data['currency_ids'] as $currency_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "jpos_location_to_currency SET jpos_location_id = '" . (int)$jpos_location_id . "', currency_id = '" . (int)$currency_id . "'");
			}
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "jpos_location_to_language WHERE jpos_location_id = '" . (int)$jpos_location_id . "'");

		if (isset($data['language_ids'])) {
			foreach ($data['language_ids'] as $language_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "jpos_location_to_language SET jpos_location_id = '" . (int)$jpos_location_id . "', language_id = '" . (int)$language_id . "'");
			}
		}
	}

	public function deleteLocation($jpos_location_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "jpos_location WHERE jpos_location_id = '" . (int)$jpos_location_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "jpos_location_to_currency WHERE jpos_location_id = '" . (int)$jpos_location_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "jpos_location_to_language WHERE jpos_location_id = '" . (int)$jpos_location_id . "'");

	}

	public function getLocation($jpos_location_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "jpos_location WHERE jpos_location_id = '" . (int)$jpos_location_id . "'");

		if ($query->num_rows) {
			$query->row['currency_ids'] = $this->getLocationCurrencies($jpos_location_id);
			$query->row['language_ids'] = $this->getLocationLanguages($jpos_location_id);
		}

		return $query->row;
	}

	public function getLocations($data = array()) {

		$sql = "SELECT * FROM " . DB_PREFIX . "jpos_location";

		$sort_data = array(
			'name',
			'description'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY name";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;

	}

	public function getTotalLocations() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "jpos_location");

		return $query->row['total'];
	}

	public function getLocationCurrencies($jpos_location_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "jpos_location_to_currency WHERE jpos_location_id = '" . (int)$jpos_location_id . "'");

		$currency_data = array();
		foreach ($query->rows as $row) {
			$currency_data[] = $row['currency_id'];
		}

		return $currency_data;
	}

	public function getLocationLanguages($jpos_location_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "jpos_location_to_language WHERE jpos_location_id = '" . (int)$jpos_location_id . "'");

		$language_data = array();
		foreach ($query->rows as $row) {
			$language_data[] = $row['language_id'];
		}

		return $language_data;
	}

}