<?php
class ControllerJposUserLevel extends controller {
	private $error = array();

	public function __construct($registry) {
		parent::__construct($registry);

		if(!$registry->has('jposadmin')) {
			$registry->set('jposadmin', new \JPos\JPosAdmin($registry));
		}

	}

	public function index() {
		$this->load->language('jpos/user_level');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/user_level');
		$this->load->model('jpos/user_level_permission');

		$this->document->addStyle('view/stylesheet/jpos/stylesheet.css');

		$this->getList();
	}

	public function add() {
		$this->load->language('jpos/user_level');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/user_level');
		$this->load->model('jpos/user_level_permission');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_jpos_user_level->addJposUser($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('jpos/user_level', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {

		$this->document->addStyle('view/stylesheet/jpos/stylesheet.css');

		$this->load->language('jpos/user_level');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/user_level');
		$this->load->model('jpos/user_level_permission');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_jpos_user_level->editJposUserLevel($this->request->get['jpos_user_level_id'], $this->request->post);
 
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('jpos/user_level', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true));
		}
		
		$this->getForm();
	}

	public function delete() {
		$this->load->language('jpos/user_level');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/user_level');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $jpos_user_level_id) {
				$this->model_jpos_user_level->deleteJposUserLevel($jpos_user_level_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('jpos/user_level', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('jpos/user_level', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true)
		);

		$data['add'] = $this->url->link('jpos/user_level/add', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);
		$data['delete'] = $this->url->link('jpos/user_level/delete', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);

		$data['user_levels'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$user_total = $this->model_jpos_user_level->getTotalJposUserLevels();

		$results = $this->model_jpos_user_level->getJposUserLevels($filter_data);

		foreach ($results as $result) {
			$data['user_levels'][] = array(
				'jpos_user_level_id'    => $result['jpos_user_level_id'],
				'name'   => $result['name'], 
				'edit'       => $this->url->link('jpos/user_level/edit', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&jpos_user_level_id=' . $result['jpos_user_level_id'] . $url, true)
			);
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_confirm'] = $this->language->get('text_confirm');

		$data['column_name'] = $this->language->get('column_name'); 
		$data['column_action'] = $this->language->get('column_action');

		$data['button_add'] = $this->language->get('button_add');
		$data['button_edit'] = $this->language->get('button_edit');
		$data['button_delete'] = $this->language->get('button_delete');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_name'] = $this->url->link('jpos/user_level', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&sort=name' . $url, true);
		 
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $user_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('jpos/user_level', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($user_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($user_total - $this->config->get('config_limit_admin'))) ? $user_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $user_total, ceil($user_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->jposadmin->loadView('jpos/user_level_list', $data));
	}

	protected function getForm() {
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_form'] = !isset($this->request->get['jpos_user_level_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_select'] = $this->language->get('text_select');

		$data['tab_personal'] = $this->language->get('tab_personal');
		$data['tab_store'] = $this->language->get('tab_store');
		$data['tab_user_level'] = $this->language->get('tab_user_level');

		$data['entry_name'] = $this->language->get('entry_name');
		 
		$data['entry_level_name'] = $this->language->get('entry_level_name');
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = '';
		} 
 
  
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('jpos/user_level', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true)
		);

		if (!isset($this->request->get['jpos_user_level_id'])) {
			$data['action'] = $this->url->link('jpos/user_level/add', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);
		} else {
			$data['action'] = $this->url->link('jpos/user_level/edit', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&jpos_user_level_id=' . $this->request->get['jpos_user_level_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('jpos/user_level', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);

		$this->load->model('jpos/location');
		$data['jpos_locations'] = $this->model_jpos_location->getLocations();
		 
		if (isset($this->request->get['jpos_user_level_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$user_info = $this->model_jpos_user_level->getJposUserLevel($this->request->get['jpos_user_level_id']);
		} 
		$data['jpos_user_level_permissions'] = $this->model_jpos_user_level_permission->getUserLevelPermissions();
		if (isset($this->request->post['jpos_user_level_id'])) {
			$data['jpos_user_level_id'] = $this->request->post['jpos_user_level_id'];
		} elseif (isset($user_info)) {
			$data['jpos_user_level_id'] = $user_info['jpos_user_level_id'];
		} else {
			$data['jpos_user_level_id'] = '';
		}

		if (isset($this->request->post['name'])) {
			$data['name'] = $this->request->post['name'];
		} elseif (isset($user_info)) {
			$data['name'] = $user_info['name'];
		} else {
			$data['name'] = '';
		}
  
      
		$this->load->model('tool/image');
 
		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
   
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		$data['selected'] = null; 
		if($data['jpos_user_level_id']){
			$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "level_permission`  WHERE  jpos_user_level_id = '" . (int)$data['jpos_user_level_id'] . "'");
			 
			foreach($query->rows as $row){
				$data['selected'][$row['jpos_user_level_id']][] = $row['jpos_user_level_permission_id'];
			}
		} 
		$this->response->setOutput($this->jposadmin->loadView('jpos/user_level_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'jpos/user_level')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 20)) {
			$this->error['name'] = $this->language->get('error_name');
		}

		$user_info = $this->model_jpos_user_level->getJposUserLevelByname($this->request->post['name']);

		if (!isset($this->request->get['jpos_user_level_id'])) {
			if ($user_info) {
				$this->error['warning'] = $this->language->get('error_exists_name');
			}
		} else {
			if ($user_info && ($this->request->get['jpos_user_level_id'] != $user_info['jpos_user_level_id'])) {
				$this->error['warning'] = $this->language->get('error_exists_name');
			}
		}
 
		$user_info = $this->model_jpos_user_level->getJposUserLevelByname($this->request->post['name']);

		if (!isset($this->request->get['jpos_user_level_id'])) {
			if ($user_info) {
				$this->error['warning'] = $this->language->get('error_exists_email');
			}
		} else {
			if ($user_info && ($this->request->get['jpos_user_level_id'] != $user_info['jpos_user_level_id'])) {
				$this->error['warning'] = $this->language->get('error_exists_email');
			}
		}
 
		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'jpos/user_level')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		foreach ($this->request->post['selected'] as $jpos_user_level_id) {
			if ($this->user->getId() == $jpos_user_level_id) {
				$this->error['warning'] = $this->language->get('error_account');
			}
		}

		return !$this->error;
	}
}