<?php
class ControllerJposUser extends controller {
	private $error = array();

	public function __construct($registry) {
		parent::__construct($registry);

		if(!$registry->has('jposadmin')) {
			$registry->set('jposadmin', new \JPos\JPosAdmin($registry));
		}

	}

	public function index() {
		$this->load->language('jpos/user');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/user');

		$this->document->addStyle('view/stylesheet/jpos/stylesheet.css');

		$this->getList();
	}

	public function add() {
		$this->load->language('jpos/user');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/user');
		$this->load->model('jpos/user_level');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_jpos_user->addJposUser($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('jpos/user', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {

		$this->document->addStyle('view/stylesheet/jpos/stylesheet.css');

		$this->load->language('jpos/user');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/user');
		$this->load->model('jpos/user_level'); 

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_jpos_user->editJposUser($this->request->get['jpos_user_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('jpos/user', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('jpos/user');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/user');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $jpos_user_id) {
				$this->model_jpos_user->deleteJposUser($jpos_user_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('jpos/user', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'username';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('jpos/user', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true)
		);

		$data['add'] = $this->url->link('jpos/user/add', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);
		$data['delete'] = $this->url->link('jpos/user/delete', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);

		$data['users'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$user_total = $this->model_jpos_user->getTotalJposUsers();

		$results = $this->model_jpos_user->getJposUsers($filter_data);

		foreach ($results as $result) {
			$data['users'][] = array(
				'jpos_user_id'    => $result['jpos_user_id'],
				'username'   => $result['username'],
				'status'     => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
				'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
				'edit'       => $this->url->link('jpos/user/edit', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&jpos_user_id=' . $result['jpos_user_id'] . $url, true)
			);
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_confirm'] = $this->language->get('text_confirm');

		$data['column_username'] = $this->language->get('column_username');
		$data['column_status'] = $this->language->get('column_status');
		$data['column_date_added'] = $this->language->get('column_date_added');
		$data['column_action'] = $this->language->get('column_action');

		$data['button_add'] = $this->language->get('button_add');
		$data['button_edit'] = $this->language->get('button_edit');
		$data['button_delete'] = $this->language->get('button_delete');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_username'] = $this->url->link('jpos/user', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&sort=username' . $url, true);
		$data['sort_status'] = $this->url->link('jpos/user', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&sort=status' . $url, true);
		$data['sort_date_added'] = $this->url->link('jpos/user', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&sort=date_added' . $url, true);

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $user_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('jpos/user', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($user_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($user_total - $this->config->get('config_limit_admin'))) ? $user_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $user_total, ceil($user_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->jposadmin->loadView('jpos/user_list', $data));
	}

	protected function getForm() {
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_form'] = !isset($this->request->get['jpos_user_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_select'] = $this->language->get('text_select');

		$data['tab_personal'] = $this->language->get('tab_personal');
		$data['tab_store'] = $this->language->get('tab_store');
		$data['tab_user_level'] = $this->language->get('tab_user_level');

		$data['entry_username'] = $this->language->get('entry_username');
		$data['entry_password'] = $this->language->get('entry_password');
		$data['entry_confirm'] = $this->language->get('entry_confirm');
		$data['entry_firstname'] = $this->language->get('entry_firstname');
		$data['entry_lastname'] = $this->language->get('entry_lastname');
		$data['entry_email'] = $this->language->get('entry_email');
		$data['entry_access_token'] = $this->language->get('entry_access_token');
		$data['entry_location'] = $this->language->get('entry_location');
		$data['entry_image'] = $this->language->get('entry_image');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_store_name'] = $this->language->get('entry_store_name');
		$data['entry_store_owner'] = $this->language->get('entry_store_owner');
		$data['entry_store_address'] = $this->language->get('entry_store_address');
		$data['entry_store_email'] = $this->language->get('entry_store_email');
		$data['entry_store_telephone'] = $this->language->get('entry_store_telephone');
		$data['entry_store_logo'] = $this->language->get('entry_store_logo');
		$data['entry_level_name'] = $this->language->get('entry_level_name');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['username'])) {
			$data['error_username'] = $this->error['username'];
		} else {
			$data['error_username'] = '';
		}

		if (isset($this->error['password'])) {
			$data['error_password'] = $this->error['password'];
		} else {
			$data['error_password'] = '';
		}

		if (isset($this->error['confirm'])) {
			$data['error_confirm'] = $this->error['confirm'];
		} else {
			$data['error_confirm'] = '';
		}

		if (isset($this->error['firstname'])) {
			$data['error_firstname'] = $this->error['firstname'];
		} else {
			$data['error_firstname'] = '';
		}

		if (isset($this->error['lastname'])) {
			$data['error_lastname'] = $this->error['lastname'];
		} else {
			$data['error_lastname'] = '';
		}

		if (isset($this->error['email'])) {
			$data['error_email'] = $this->error['email'];
		} else {
			$data['error_email'] = '';
		}
		
		if (isset($this->error['access_token'])) {
			$data['error_access_token'] = $this->error['access_token'];
		} else {
			$data['error_access_token'] = '';
		}

		if (isset($this->error['locations'])) {
			$data['error_locations'] = $this->error['locations'];
		} else {
			$data['error_locations'] = '';
		}

		if (isset($this->error['store_email'])) {
			$data['error_store_email'] = $this->error['store_email'];
		} else {
			$data['error_store_email'] = '';
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('jpos/user', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true)
		);

		if (!isset($this->request->get['jpos_user_id'])) {
			$data['action'] = $this->url->link('jpos/user/add', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);
		} else {
			$data['action'] = $this->url->link('jpos/user/edit', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&jpos_user_id=' . $this->request->get['jpos_user_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('jpos/user', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);

		$this->load->model('jpos/location');
		$data['jpos_locations'] = $this->model_jpos_location->getLocations();

		if (isset($this->request->get['jpos_user_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$user_info = $this->model_jpos_user->getJposUser($this->request->get['jpos_user_id']);
		}
		
		$user_levels = $this->model_jpos_user_level->getJposUserLevels();
         
		if (isset($this->request->post['username'])) {
			$data['username'] = $this->request->post['username'];
		} elseif (isset($user_info)) {
			$data['username'] = $user_info['username'];
		} else {
			$data['username'] = '';
		}

		if (isset($this->request->post['password'])) {
			$data['password'] = $this->request->post['password'];
		} else {
			$data['password'] = '';
		}

		if (isset($this->request->post['confirm'])) {
			$data['confirm'] = $this->request->post['confirm'];
		} else {
			$data['confirm'] = '';
		}

		if (isset($this->request->post['firstname'])) {
			$data['firstname'] = $this->request->post['firstname'];
		} elseif (isset($user_info['firstname'])) {
			$data['firstname'] = $user_info['firstname'];
		} else {
			$data['firstname'] = '';
		}

		if (isset($this->request->post['lastname'])) {
			$data['lastname'] = $this->request->post['lastname'];
		} elseif (isset($user_info['lastname'])) {
			$data['lastname'] = $user_info['lastname'];
		} else {
			$data['lastname'] = '';
		}

		if (isset($this->request->post['email'])) {
			$data['email'] = $this->request->post['email'];
		} elseif (isset($user_info['email'])) {
			$data['email'] = $user_info['email'];
		} else {
			$data['email'] = '';
		}
		
		if (isset($this->request->post['access_token'])) {
			$data['access_token'] = $this->request->post['access_token'];
		} elseif (isset($user_info['access_token'])) {
			$data['access_token'] = $user_info['access_token'];
		} else {
			$data['access_token'] = '';
		}
		
		if (isset($this->request->post['jpos_user_level_id'])) {
			$data['jpos_user_level_id'] = $this->request->post['jpos_user_level_id'];
		} elseif (isset($user_info['jpos_user_level_id'])) {
			$data['jpos_user_level_id'] = $user_info['jpos_user_level_id'];
		} else {
			$data['jpos_user_level_id'] = '';
		}

		if (isset($this->request->post['locations'])) {
			$data['locations'] = $this->request->post['locations'];
		} elseif (isset($user_info['locations'])) {
			$data['locations'] = (array)$user_info['locations'];
		} else {
			$data['locations'] = array();
		}

		if (isset($this->request->post['image'])) {
			$data['image'] = $this->request->post['image'];
		} elseif (isset($user_info['image'])) {
			$data['image'] = $user_info['image'];
		} else {
			$data['image'] = '';
		}

		$this->load->model('tool/image');

		if (isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 100, 100);
		} elseif (isset($user_info) && $user_info['image'] && is_file(DIR_IMAGE . $user_info['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($user_info['image'], 100, 100);
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);

		if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (isset($user_info['status'])) {
			$data['status'] = $user_info['status'];
		} else {
			$data['status'] = 0;
		}


		if (isset($this->request->post['store_name'])) {
			$data['store_name'] = $this->request->post['store_name'];
		} elseif (isset($user_info['store_name'])) {
			$data['store_name'] = $user_info['store_name'];
		} else {
			$data['store_name'] = $this->config->get('config_name');
		}

		if (isset($this->request->post['store_owner'])) {
			$data['store_owner'] = $this->request->post['store_owner'];
		} elseif (isset($user_info['store_owner'])) {
			$data['store_owner'] = $user_info['store_owner'];
		} else {
			$data['store_owner'] = $this->config->get('config_owner');
		}

		if (isset($this->request->post['store_address'])) {
			$data['store_address'] = $this->request->post['store_address'];
		} elseif (isset($user_info['store_address'])) {
			$data['store_address'] = $user_info['store_address'];
		} else {
			$data['store_address'] = $this->config->get('config_address');
		}

		if (isset($this->request->post['store_email'])) {
			$data['store_email'] = $this->request->post['store_email'];
		} elseif (isset($user_info['store_email'])) {
			$data['store_email'] = $user_info['store_email'];
		} else {
			$data['store_email'] = $this->config->get('config_email');
		}

		if (isset($this->request->post['store_telephone'])) {
			$data['store_telephone'] = $this->request->post['store_telephone'];
		} elseif (isset($user_info['store_telephone'])) {
			$data['store_telephone'] = $user_info['store_telephone'];
		} else {
			$data['store_telephone'] = $this->config->get('config_telephone');
		}

		if (isset($this->request->post['store_logo'])) {
			$data['store_logo'] = $this->request->post['store_logo'];
		} elseif (isset($user_info['store_logo'])) {
			$data['store_logo'] = $user_info['store_logo'];
		} else {
			$data['store_logo'] = $this->config->get('config_logo');
		}

        $data['user_levels'] = $user_levels;
		if (isset($data['store_logo']) && is_file(DIR_IMAGE . $data['store_logo'])) {
			$data['thumb_store_logo'] = $this->model_tool_image->resize($data['store_logo'], 100, 100);
		} else {
			$data['thumb_store_logo'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->jposadmin->loadView('jpos/user_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'jpos/user')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['username']) < 3) || (utf8_strlen($this->request->post['username']) > 20)) {
			$this->error['username'] = $this->language->get('error_username');
		}

		$user_info = $this->model_jpos_user->getJposUserByUsername($this->request->post['username']);

		if (!isset($this->request->get['jpos_user_id'])) {
			if ($user_info) {
				$this->error['warning'] = $this->language->get('error_exists_username');
			}
		} else {
			if ($user_info && ($this->request->get['jpos_user_id'] != $user_info['jpos_user_id'])) {
				$this->error['warning'] = $this->language->get('error_exists_username');
			}
		}

		if ((utf8_strlen(trim($this->request->post['firstname'])) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
			$this->error['firstname'] = $this->language->get('error_firstname');
		}

		if ((utf8_strlen(trim($this->request->post['lastname'])) < 1) || (utf8_strlen(trim($this->request->post['lastname'])) > 32)) {
			$this->error['lastname'] = $this->language->get('error_lastname');
		}

		if ((utf8_strlen($this->request->post['email']) > 96) || !filter_var($this->request->post['email'], FILTER_VALIDATE_EMAIL)) {
			$this->error['email'] = $this->language->get('error_email');
		}

		if (!isset($this->request->post['locations'])) {
			$this->error['locations'] = $this->language->get('error_locations');
		}

		$user_info = $this->model_jpos_user->getJposUserByEmail($this->request->post['email']);

		if (!isset($this->request->get['jpos_user_id'])) {
			if ($user_info) {
				$this->error['warning'] = $this->language->get('error_exists_email');
			}
		} else {
			if ($user_info && ($this->request->get['jpos_user_id'] != $user_info['jpos_user_id'])) {
				$this->error['warning'] = $this->language->get('error_exists_email');
			}
		}

		if ($this->request->post['password'] || (!isset($this->request->get['jpos_user_id']))) {
			if ((utf8_strlen($this->request->post['password']) < 4) || (utf8_strlen($this->request->post['password']) > 20)) {
				$this->error['password'] = $this->language->get('error_password');
			}

			if ($this->request->post['password'] != $this->request->post['confirm']) {
				$this->error['confirm'] = $this->language->get('error_confirm');
			}
		}

		if ((utf8_strlen($this->request->post['store_email']) > 96) || !filter_var($this->request->post['store_email'], FILTER_VALIDATE_EMAIL)) {
			$this->error['store_email'] = $this->language->get('error_store_email');
		}

		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'jpos/user')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		foreach ($this->request->post['selected'] as $jpos_user_id) {
			if ($this->user->getId() == $jpos_user_id) {
				$this->error['warning'] = $this->language->get('error_account');
			}
		}

		return !$this->error;
	}
}