<?php
class ControllerJposTop extends controller {
	private $error = array();

	public function __construct($registry) {
		parent::__construct($registry);

		if(!$registry->has('jposadmin')) {
			$registry->set('jposadmin', new \JPos\JPosAdmin($registry));
		}

	}

	public function index() {
		$this->load->language('jpos/top');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/top'); 

		$this->document->addStyle('view/stylesheet/jpos/stylesheet.css');

		$this->getList();
	}

	public function add() {
		$this->load->language('jpos/top');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/top'); 

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_jpos_top->addJposTop($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('jpos/top', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {

		$this->document->addStyle('view/stylesheet/jpos/stylesheet.css');

		$this->load->language('jpos/top');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/top'); 

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_jpos_top->editJposTop($this->request->get['jpos_top_id'], $this->request->post);
 
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('jpos/top', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true));
		}
		
		$this->getForm();
	}

	public function delete() {
		$this->load->language('jpos/top');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/top');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) { 
			foreach ($this->request->post['selected'] as $jpos_top_id) {
				$this->model_jpos_top->deleteJposTop($jpos_top_id);
			} 
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('jpos/top', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('jpos/top', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true)
		);

		$data['add'] = $this->url->link('jpos/top/add', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);
		$data['delete'] = $this->url->link('jpos/top/delete', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);

		$data['tops'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$jpos_top_total = $this->model_jpos_top->getTotalJposTop();

		$results = $this->model_jpos_top->getJposTops($filter_data);

		foreach ($results as $result) {
			$data['tops'][] = array(
				'jpos_top_id'    => $result['jpos_top_id'],
				'name'   => $result['name'], 
				'edit'       => $this->url->link('jpos/top/edit', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&jpos_top_id=' . $result['jpos_top_id'] . $url, true)
			);
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_confirm'] = $this->language->get('text_confirm');

		$data['column_name'] = $this->language->get('column_name'); 
		$data['column_action'] = $this->language->get('column_action');

		$data['button_add'] = $this->language->get('button_add');
		$data['button_edit'] = $this->language->get('button_edit');
		$data['button_delete'] = $this->language->get('button_delete');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_name'] = $this->url->link('jpos/top', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&sort=name' . $url, true);
		 
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $jpos_top_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('jpos/top', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($jpos_top_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($jpos_top_total - $this->config->get('config_limit_admin'))) ? $jpos_top_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $jpos_top_total, ceil($jpos_top_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->jposadmin->loadView('jpos/top_list', $data));
	}

	protected function getForm() {
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_form'] = !isset($this->request->get['jpos_top_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_select'] = $this->language->get('text_select');

		$data['tab_personal'] = $this->language->get('tab_personal');
		$data['tab_store'] = $this->language->get('tab_store');
		$data['tab_top'] = $this->language->get('tab_top');

		$data['entry_name'] = $this->language->get('entry_name');
		 
		$data['entry_level_name'] = $this->language->get('entry_level_name');
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = '';
		} 
 
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
 
		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		} 

		$data['sort_name'] = $this->url->link('jpos/top', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&sort=name' . $url, true);
		 
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		$jpos_top_total = $this->model_jpos_top->getTotalJposTop();
		 
		$pagination = new Pagination();
		$pagination->total = $jpos_top_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('jpos/top', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();  
		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('jpos/top', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true)
		);

		if (!isset($this->request->get['jpos_top_id'])) {
			$data['action'] = $this->url->link('jpos/top/add', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);
		} else {
			$data['action'] = $this->url->link('jpos/top/edit', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&jpos_top_id=' . $this->request->get['jpos_top_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('jpos/top', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);

		$this->load->model('jpos/location');
		$data['jpos_locations'] = $this->model_jpos_location->getLocations();
		 
		if (isset($this->request->get['jpos_top_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$user_info = $this->model_jpos_top->getJposTop($this->request->get['jpos_top_id']);
		} 
		 
		if (isset($this->request->post['jpos_top_id'])) {
			$data['jpos_top_id'] = $this->request->post['jpos_top_id'];
		} elseif (isset($user_info)) {
			$data['jpos_top_id'] = $user_info['jpos_top_id'];
		} else {
			$data['jpos_top_id'] = '';
		}

		if (isset($this->request->post['name'])) {
			$data['name'] = $this->request->post['name'];
		} elseif (isset($user_info)) {
			$data['name'] = $user_info['name'];
		} else {
			$data['name'] = '';
		}  
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		 
		$this->response->setOutput($this->jposadmin->loadView('jpos/top_form', $data));
	}

	protected function validateForm() {
		 
		if (!$this->user->hasPermission('modify', 'jpos/top')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 20)) {
			$this->error['name'] = $this->language->get('error_name');
		}

		$user_info = $this->model_jpos_top->getJposTop($this->request->post['jpos_top_id']);

		if (!isset($this->request->get['jpos_top_id'])) {
			if ($user_info) {
				$this->error['warning'] = $this->language->get('error_exists_name');
			}
		} else {
			if ($user_info && ($this->request->get['jpos_top_id'] != $user_info['jpos_top_id'])) {
				$this->error['warning'] = $this->language->get('error_exists_name');
			}
		}
 
		$user_info = $this->model_jpos_top->getJposTopByName($this->request->post['name']);

		if (!isset($this->request->get['jpos_top_id'])) {
			if ($user_info) {
				$this->error['warning'] = $this->language->get('error_exists_email');
			}
		} else {
			if ($user_info && ($this->request->get['jpos_top_id'] != $user_info['jpos_top_id'])) {
				$this->error['warning'] = $this->language->get('error_exists_email');
			}
		}
 
		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'jpos/top')) {
			$this->error['warning'] = $this->language->get('error_permission');
		} 
		return !$this->error;
	}
}