<?php
class ControllerJposSettings extends controller {
	private $error = array();

	public function __construct($registry) {
		parent::__construct($registry);

		if(!$registry->has('jposadmin')) {
			$registry->set('jposadmin', new \JPos\JPosAdmin($registry));
		}

	}

	public function getMenu() {
		$menus = array();

		$this->load->language('jpos/adminmenu');

		$jpos = array();
		if ($this->user->hasPermission('access', 'jpos/settings')) {
			$jpos[] = array(
				'name'	   => $this->language->get('text_setting'),
				'href'     => $this->url->link('jpos/settings', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true),
				'children' => array()
			);
		}

		if($this->config->get('jpos_status')) {
		if ($this->user->hasPermission('access', 'jpos/location')) {
			$jpos[] = array(
				'name'	   => $this->language->get('text_locations'),
				'href'     => $this->url->link('jpos/location', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true),
				'children' => array()
			);
		}

		$users = array();

		if ($this->user->hasPermission('access', 'jpos/user')) {
			$users[] = array(
				'name'	   => $this->language->get('text_users'),
				'href'     => $this->url->link('jpos/user', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true),
				'children' => array()
			);
		}
		
		if ($this->user->hasPermission('access', 'jpos/user_level')) {
			$users[] = array(
				'name'	   => $this->language->get('text_level_users'),
				'href'     => $this->url->link('jpos/user_level', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true),
				'children' => array()
			);
			
			$users[] = array(
				'name'	   => $this->language->get('text_top'),
				'href'     => $this->url->link('jpos/top', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true),
				'children' => array()
			);
		}

		if ($users) {
			$jpos[] = array(
				'name'	   => $this->language->get('text_users'),
				'href'     => '',
				'children' => $users
			);
		}

		if ($this->user->hasPermission('access', 'jpos/extension')) {
			$jpos[] = array(
				'name'	   => $this->language->get('text_jpos_extension'),
				'href'     => $this->url->link('jpos/extension', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true),
				'children' => array()
			);
		}
		}

		if ($jpos) {
			$menus = array(
				'id'       => 'menu-jpos',
				'icon'	   => 'fa fa-cubes',
				'name'	   => $this->language->get('text_jpos'),
				'href'     => '',
				'children' => $jpos
			);
		}

		return $menus;
	}

	public function index() {
		$this->load->model('jpos/settings');

		$this->model_jpos_settings->CreateJadePosTables();

		$this->load->language('jpos/settings');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->document->addStyle('view/javascript/jquery/jpos/colorpicker/css/bootstrap-colorpicker.css');
		$this->document->addScript('view/javascript/jquery/jpos/colorpicker/js/bootstrap-colorpicker.js');

		$this->document->addStyle('view/stylesheet/jpos/stylesheet.css');

		$this->load->model('setting/setting');

		$store_id = $data['store_id'] = 0;

		if(isset($this->request->get['store_id'])) {
			$store_id = $data['store_id'] = $this->request->get['store_id'];
		}

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('jpos', $this->request->post, $store_id);

			$this->session->data['success'] = $this->language->get('text_success');


			$this->response->redirect($this->url->link('jpos/settings', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_show'] = $this->language->get('text_show');
		$data['text_hide'] = $this->language->get('text_hide');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');

		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_display_shipping'] = $this->language->get('entry_display_shipping');
		$data['entry_css'] = $this->language->get('entry_css');
		$data['entry_order_statues_colors'] = $this->language->get('entry_order_statues_colors');
		$data['entry_order_note'] = $this->language->get('entry_order_note');
		$data['entry_total_display'] = $this->language->get('entry_total_display');
		$data['entry_cart_block'] = $this->language->get('entry_cart_block');


		$data['button_save'] = $this->language->get('button_save');


		$data['tab_general'] = $this->language->get('tab_general');
		$data['tab_css'] = $this->language->get('tab_css');
		$data['tab_support'] = $this->language->get('tab_support');


		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else if(isset($this->session->data['warning'])) {
			$data['error_warning'] = $this->session->data['warning'];
			unset($this->session->data['warning']);
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}


		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('jpos/settings', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['action'] = $this->url->link('jpos/settings', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true);

		$data['stores'] = $this->jposadmin->getStores(array(
			'href' => array(
				'find' => array(
					'store_id' => '[STORE_ID]',
					'name' => '[STORE_NAME]',
					'url' => '[STORE_URL]',
					'ssl' => '[STORE_SSL]'
				),
				'str' => $this->url->link('jpos/settings', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] .'&store_id=[STORE_ID]', true)
			)
		));

		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		array_unshift($data['order_statuses'], array(
			'order_status_id'  => '0',
			'name' => $this->language->get('text_missing'),
		));

		$module_info = $this->model_setting_setting->getSetting('jpos', $store_id);

		if (isset($this->request->post['jpos_status'])) {
			$data['jpos_status'] = $this->request->post['jpos_status'];
		} else if(isset($module_info['jpos_status'])) {
			$data['jpos_status'] = $module_info['jpos_status'];
		} else {
			$data['jpos_status'] = '0';
		}

		if (isset($this->request->post['jpos_css'])) {
			$data['jpos_css'] = $this->request->post['jpos_css'];
		} else if(isset($module_info['jpos_css'])) {
			$data['jpos_css'] = $module_info['jpos_css'];
		} else {
			$data['jpos_css'] = '';
		}

		if (isset($this->request->post['jpos_colors_order_status'])) {
			$data['jpos_colors_order_status'] = $this->request->post['jpos_colors_order_status'];
		} else if(isset($module_info['jpos_colors_order_status'])) {
			$data['jpos_colors_order_status'] = $module_info['jpos_colors_order_status'];
		} else {
			$data['jpos_colors_order_status'] = '';
		}

		if (isset($this->request->post['jpos_display_shipping'])) {
			$data['jpos_display_shipping'] = $this->request->post['jpos_display_shipping'];
		} else if(isset($module_info['jpos_display_shipping'])) {
			$data['jpos_display_shipping'] = $module_info['jpos_display_shipping'];
		} else {
			$data['jpos_display_shipping'] = '';
		}

		if (isset($this->request->post['jpos_order_note'])) {
			$data['jpos_order_note'] = $this->request->post['jpos_order_note'];
		} else if(isset($module_info['jpos_order_note'])) {
			$data['jpos_order_note'] = $module_info['jpos_order_note'];
		} else {
			$data['jpos_order_note'] = '';
		}

		if (isset($this->request->post['jpos_total_display'])) {
			$data['jpos_total_display'] = $this->request->post['jpos_total_display'];
		} else if(isset($module_info['jpos_total_display'])) {
			$data['jpos_total_display'] = $module_info['jpos_total_display'];
		} else {
			$data['jpos_total_display'] = '';
		}

		if (isset($this->request->post['jpos_cart_block'])) {
			$data['jpos_cart_block'] = $this->request->post['jpos_cart_block'];
		} else if(isset($module_info['jpos_cart_block'])) {
			$data['jpos_cart_block'] = $module_info['jpos_cart_block'];
		} else {
			$data['jpos_cart_block'] = '';
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->jposadmin->loadView('jpos/settings', $data));

	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'jpos/settings')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}


		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;

	}

}