<?php
class ControllerJposLocation extends Controller {
	private $error = array();

	public function __construct($registry) {
		parent::__construct($registry);

		if(!$registry->has('jposadmin')) {
			$registry->set('jposadmin', new \JPos\JPosAdmin($registry));
		}

		$this->document->addStyle('view/stylesheet/jpos/stylesheet.css');

	}

	public function index() {
		$this->load->language('jpos/location');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/location');

		$this->getList();
	}

	public function add() {
		$this->load->language('jpos/location');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/location');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_jpos_location->addLocation($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('jpos/location', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('jpos/location');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/location');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_jpos_location->editLocation($this->request->get['jpos_location_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('jpos/location', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('jpos/location');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('jpos/location');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $jpos_location_id) {
				$this->model_jpos_location->deleteLocation($jpos_location_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('jpos/location', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('jpos/location', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true)
		);

		$data['add'] = $this->url->link('jpos/location/add', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);
		$data['delete'] = $this->url->link('jpos/location/delete', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);

		$data['locations'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$location_total = $this->model_jpos_location->getTotalLocations();

		$results = $this->model_jpos_location->getLocations($filter_data);

		foreach ($results as $result) {
			$data['locations'][] = array(
				'jpos_location_id' => $result['jpos_location_id'],
				'name'        => $result['name'],
				'description' => $result['description'],
				'edit'        => $this->url->link('jpos/location/edit', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&jpos_location_id=' . $result['jpos_location_id'] . $url, true)
			);
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_confirm'] = $this->language->get('text_confirm');

		$data['column_name'] = $this->language->get('column_name');
		$data['column_description'] = $this->language->get('column_description');
		$data['column_action'] = $this->language->get('column_action');

		$data['button_add'] = $this->language->get('button_add');
		$data['button_edit'] = $this->language->get('button_edit');
		$data['button_delete'] = $this->language->get('button_delete');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_name'] = $this->url->link('jpos/location', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&sort=name' . $url, true);
		$data['sort_description'] = $this->url->link('jpos/location', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&sort=description' . $url, true);

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $location_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('jpos/location', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($location_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($location_total - $this->config->get('config_limit_admin'))) ? $location_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $location_total, ceil($location_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->jposadmin->loadView('jpos/location_list', $data));
	}

	protected function getForm() {
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_form'] = !isset($this->request->get['jpos_location_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
		$data['text_all_zones'] = $this->language->get('text_all_zones');

		$data['entry_name'] = $this->language->get('entry_name');
		$data['entry_description'] = $this->language->get('entry_description');
		$data['entry_language'] = $this->language->get('entry_language');
		$data['entry_currency'] = $this->language->get('entry_currency');
		$data['entry_country'] = $this->language->get('entry_country');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');



		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = '';
		}

		if (isset($this->error['description'])) {
			$data['error_description'] = $this->error['description'];
		} else {
			$data['error_description'] = '';
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('jpos/location', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true)
		);

		if (!isset($this->request->get['jpos_location_id'])) {
			$data['action'] = $this->url->link('jpos/location/add', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);
		} else {
			$data['action'] = $this->url->link('jpos/location/edit', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&jpos_location_id=' . $this->request->get['jpos_location_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('jpos/location', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . $url, true);

		$this->load->model('localisation/country');
		$data['countries'] = $this->model_localisation_country->getCountries();

		$data['languages'] = $this->jposadmin->getLanguages();

		$this->load->model('localisation/currency');
		$data['currencies'] = $this->model_localisation_currency->getCurrencies();

		if (isset($this->request->get['jpos_location_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$location_info = $this->model_jpos_location->getLocation($this->request->get['jpos_location_id']);
		}

		$data[$this->jposadmin->JocToken] = $this->session->data[$this->jposadmin->JocToken];

		if (isset($this->request->post['name'])) {
			$data['name'] = $this->request->post['name'];
		} elseif (isset($location_info['name'])) {
			$data['name'] = $location_info['name'];
		} else {
			$data['name'] = '';
		}

		if (isset($this->request->post['description'])) {
			$data['description'] = $this->request->post['description'];
		} elseif (isset($location_info['description'])) {
			$data['description'] = $location_info['description'];
		} else {
			$data['description'] = '';
		}

		if (isset($this->request->post['country_id'])) {
			$data['country_id'] = $this->request->post['country_id'];
		} elseif (isset($location_info['country_id'])) {
			$data['country_id'] = $location_info['country_id'];
		} else {
			$data['country_id'] = '';
		}

		if (isset($this->request->post['currency_ids'])) {
			$data['currency_ids'] = $this->request->post['currency_ids'];
		} elseif (isset($location_info['currency_ids'])) {
			$data['currency_ids'] = (array)$location_info['currency_ids'];
		} else {
			$data['currency_ids'] = array();
		}

		if (isset($this->request->post['language_ids'])) {
			$data['language_ids'] = $this->request->post['language_ids'];
		} elseif (isset($location_info['language_ids'])) {
			$data['language_ids'] = (array)$location_info['language_ids'];
		} else {
			$data['language_ids'] = array();
		}


		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->jposadmin->loadView('jpos/location_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'jpos/location')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 32)) {
			$this->error['name'] = $this->language->get('error_name');
		}

		if ((utf8_strlen($this->request->post['description']) < 3) || (utf8_strlen($this->request->post['description']) > 255)) {
			$this->error['description'] = $this->language->get('error_description');
		}

		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'jpos/location')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}