<?php
class ControllerJposJposShippingJposFlat extends Controller {
	private $error = array();

	public function __construct($registry) {
		parent::__construct($registry);

		if(!$registry->has('jposadmin')) {
			$registry->set('jposadmin', new \JPos\JPosAdmin($registry));
		}

	}

	public function index() {
		$this->load->language('jpos/jpos_shipping/jpos_flat');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('jpos_flat', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('jpos/extension', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&type=jpos_shipping', true));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');
		$data['text_none'] = $this->language->get('text_none');

		$data['entry_cost'] = $this->language->get('entry_cost');
		$data['entry_tax_class'] = $this->language->get('entry_tax_class');
		$data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('jpos/extension', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&type=jpos_shipping', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('jpos/jpos_shipping/jpos_flat', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['action'] = $this->url->link('jpos/jpos_shipping/jpos_flat', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true);

		$data['cancel'] = $this->url->link('jpos/extension', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&type=jpos_shipping', true);

		if (isset($this->request->post['jpos_flat_cost'])) {
			$data['jpos_flat_cost'] = $this->request->post['jpos_flat_cost'];
		} else {
			$data['jpos_flat_cost'] = $this->config->get('jpos_flat_cost');
		}

		if (isset($this->request->post['jpos_flat_tax_class_id'])) {
			$data['jpos_flat_tax_class_id'] = $this->request->post['jpos_flat_tax_class_id'];
		} else {
			$data['jpos_flat_tax_class_id'] = $this->config->get('jpos_flat_tax_class_id');
		}

		$this->load->model('localisation/tax_class');

		$data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

		if (isset($this->request->post['jpos_flat_geo_zone_id'])) {
			$data['jpos_flat_geo_zone_id'] = $this->request->post['jpos_flat_geo_zone_id'];
		} else {
			$data['jpos_flat_geo_zone_id'] = $this->config->get('jpos_flat_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['jpos_flat_status'])) {
			$data['jpos_flat_status'] = $this->request->post['jpos_flat_status'];
		} else {
			$data['jpos_flat_status'] = $this->config->get('jpos_flat_status');
		}

		if (isset($this->request->post['jpos_flat_sort_order'])) {
			$data['jpos_flat_sort_order'] = $this->request->post['jpos_flat_sort_order'];
		} else {
			$data['jpos_flat_sort_order'] = $this->config->get('jpos_flat_sort_order');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->jposadmin->loadView('jpos/jpos_shipping/jpos_flat', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'jpos/jpos_shipping/jpos_flat')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}