<?php
class ControllerJposJposPaymentJposCash extends Controller {
	private $error = array();

	public function __construct($registry) {
		parent::__construct($registry);

		if(!$registry->has('jposadmin')) {
			$registry->set('jposadmin', new \JPos\JPosAdmin($registry));
		}

	}

	public function index() {
		$this->document->addStyle('view/stylesheet/jpos/stylesheet.css');

		$this->load->language('jpos/jpos_payment/jpos_cash');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('jpos_cash', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('jpos/extension', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&type=jpos_payment', true));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');
		$data['text_show'] = $this->language->get('text_show');
		$data['text_hide'] = $this->language->get('text_hide');

		$data['entry_order_status'] = $this->language->get('entry_order_status');
		$data['entry_total'] = $this->language->get('entry_total');
		$data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$data['entry_duringcheckout'] = $this->language->get('entry_duringcheckout');

		$data['help_total'] = $this->language->get('help_total');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('jpos/extension', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&type=jpos_payment', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('jpos/jpos_payment/jpos_cash', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['action'] = $this->url->link('jpos/jpos_payment/jpos_cash', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true);

		$data['cancel'] = $this->url->link('jpos/extension', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&type=jpos_payment', true);

		if (isset($this->request->post['jpos_cash_total'])) {
			$data['jpos_cash_total'] = $this->request->post['jpos_cash_total'];
		} else {
			$data['jpos_cash_total'] = $this->config->get('jpos_cash_total');
		}

		if (isset($this->request->post['jpos_cash_order_status_id'])) {
			$data['jpos_cash_order_status_id'] = $this->request->post['jpos_cash_order_status_id'];
		} else {
			$data['jpos_cash_order_status_id'] = $this->config->get('jpos_cash_order_status_id');
		}

		if (isset($this->request->post['jpos_cash_duringcheckout'])) {
			$data['jpos_cash_duringcheckout'] = $this->request->post['jpos_cash_duringcheckout'];
		} else {
			$data['jpos_cash_duringcheckout'] = $this->config->get('jpos_cash_duringcheckout');
		}

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['jpos_cash_geo_zone_id'])) {
			$data['jpos_cash_geo_zone_id'] = $this->request->post['jpos_cash_geo_zone_id'];
		} else {
			$data['jpos_cash_geo_zone_id'] = $this->config->get('jpos_cash_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['jpos_cash_status'])) {
			$data['jpos_cash_status'] = $this->request->post['jpos_cash_status'];
		} else {
			$data['jpos_cash_status'] = $this->config->get('jpos_cash_status');
		}

		if (isset($this->request->post['jpos_cash_sort_order'])) {
			$data['jpos_cash_sort_order'] = $this->request->post['jpos_cash_sort_order'];
		} else {
			$data['jpos_cash_sort_order'] = $this->config->get('jpos_cash_sort_order');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->jposadmin->loadView('jpos/jpos_payment/jpos_cash', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'jpos/jpos_payment/jpos_cash')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}