<?php
class ControllerJposExtensionJposTotal extends Controller {
	private $error = array();

	public function __construct($registry) {
		parent::__construct($registry);

		if(!$registry->has('jposadmin')) {
			$registry->set('jposadmin', new \JPos\JPosAdmin($registry));
		}

		if(VERSION <= '2.3.0.2') {
			$this->load->model('extension/extension');
		} else {
			$this->load->model('setting/extension');
		}

	}

	public function index() {
		$this->load->language('jpos/extension/jpos_total');



		$this->getList();
	}

	public function install() {
		$this->load->language('jpos/extension/jpos_total');



		if ($this->validate()) {
			if(VERSION <= '2.3.0.2') {
				$this->model_extension_extension->install('jpos_total', $this->request->get['extension']);
			} else {
				$this->model_setting_extension->install('jpos_total', $this->request->get['extension']);
			}

			$this->load->model('user/user_group');

			$this->model_user_user_group->addPermission($this->user->getGroupId(), 'access', 'jpos/jpos_total/' . $this->request->get['extension']);
			$this->model_user_user_group->addPermission($this->user->getGroupId(), 'modify', 'jpos/jpos_total/' . $this->request->get['extension']);

			$this->load->controller('jpos/jpos_total/' . $this->request->get['extension'] . '/install');

			$this->session->data['success'] = $this->language->get('text_success');
		}

		$this->getList();
	}

	public function uninstall() {
		$this->load->language('jpos/extension/jpos_total');



		if ($this->validate()) {
			if(VERSION <= '2.3.0.2') {
				$this->model_extension_extension->uninstall('jpos_total', $this->request->get['extension']);
			} else {
				$this->model_setting_extension->uninstall('jpos_total', $this->request->get['extension']);
			}

			$this->load->controller('jpos/jpos_total/' . $this->request->get['extension'] . '/uninstall');

			$this->session->data['success'] = $this->language->get('text_success');
		}

		$this->getList();
	}

	protected function getList() {
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_no_results'] = $this->language->get('text_no_results');

		$data['column_name'] = $this->language->get('column_name');
		$data['column_status'] = $this->language->get('column_status');
		$data['column_sort_order'] = $this->language->get('column_sort_order');
		$data['column_action'] = $this->language->get('column_action');

		$data['button_edit'] = $this->language->get('button_edit');
		$data['button_install'] = $this->language->get('button_install');
		$data['button_uninstall'] = $this->language->get('button_uninstall');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}



		if(VERSION <= '2.3.0.2') {
			$extensions = $this->model_extension_extension->getInstalled('jpos_total');
		} else {
			$extensions = $this->model_setting_extension->getInstalled('jpos_total');
		}

		foreach ($extensions as $key => $value) {
			if (!is_file(DIR_APPLICATION . 'controller/jpos/jpos_total/' . $value . '.php')) {
				if(VERSION <= '2.3.0.2') {
					$this->model_extension_extension->uninstall('jpos_total', $value);
				} else {
					$this->model_setting_extension->uninstall('jpos_total', $value);
				}

				unset($extensions[$key]);
			}
		}

		$data['extensions'] = array();

		// Compatibility code for old extension folders
		$files = glob(DIR_APPLICATION . 'controller/{jpos/jpos_total,jpos_total}/*.php', GLOB_BRACE);

		if ($files) {
			foreach ($files as $file) {
				$extension = basename($file, '.php');

				$this->load->language('jpos/jpos_total/' . $extension);

				$data['extensions'][] = array(
					'name'       => $this->language->get('heading_title'),
					'status'     => $this->config->get($extension . '_status') ? $this->language->get('text_enabled') : $this->language->get('text_disabled'),
					'sort_order' => $this->config->get($extension . '_sort_order'),
					'install'   => $this->url->link('jpos/extension/jpos_total/install', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&extension=' . $extension, true),
					'uninstall' => $this->url->link('jpos/extension/jpos_total/uninstall', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken] . '&extension=' . $extension, true),
					'installed' => in_array($extension, $extensions),
					'edit'      => $this->url->link('jpos/jpos_total/' . $extension, $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
				);
			}
		}


		foreach ($data['extensions'] as $ext_key => $ext_value) {
			$sort_order[$ext_key] = $ext_value['sort_order'];
		}

		array_multisort($sort_order, SORT_ASC, $data['extensions']);

		$this->response->setOutput($this->jposadmin->loadView('jpos/extension/jpos_total', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'jpos/extension/jpos_total')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}