<?php
class ControllerJposExtension extends Controller {
	private $error = array();

	public function __construct($registry) {
		parent::__construct($registry);

		if(!$registry->has('jposadmin')) {
			$registry->set('jposadmin', new \JPos\JPosAdmin($registry));
		}

	}

	public function index() {
		$this->load->language('jpos/extension');

		$this->document->addStyle('view/stylesheet/jpos/stylesheet.css');

		$this->document->setTitle($this->language->get('heading_title'));

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('jpos/extension', $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
		);

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_list'] = $this->language->get('text_list');
		$data['text_type'] = $this->language->get('text_type');
		$data['text_filter'] = $this->language->get('text_filter');
		$data['text_loading'] = $this->language->get('text_loading');
		$data['text_confirm'] = $this->language->get('text_confirm');

		$data[$this->jposadmin->JocToken] = $this->session->data[$this->jposadmin->JocToken];

		if (isset($this->request->get['type'])) {
			$data['type'] = $this->request->get['type'];
		} else {
			$data['type'] = '';
		}

		$data['categories'] = array();

		$files = glob(DIR_APPLICATION . 'controller/jpos/extension/*.php', GLOB_BRACE);

		foreach ($files as $file) {
			$extension = basename($file, '.php');

			// Compatibility code for old extension folders
			$this->load->language('jpos/extension/' . $extension);

			if ($this->user->hasPermission('access', 'jpos/extension/' . $extension)) {
				$files = glob(DIR_APPLICATION . 'controller/{jpos/' . $extension . ',' . $extension . '}/*.php', GLOB_BRACE);

				$data['categories'][] = array(
					'code' => $extension,
					'text' => $this->language->get('heading_title') . ' (' . count($files) .')',
					'href' => $this->url->link('jpos/extension/' . $extension, $this->jposadmin->JocToken .'=' . $this->session->data[$this->jposadmin->JocToken], true)
				);
			}
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->jposadmin->loadView('jpos/extension', $data));
	}
}